﻿<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Kalend" %>
<%@ import Namespace="Soneta.Place" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ import Namespace="System.Collections.Generic" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page Language="c#" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Świadectwo pracy</title>
		<script runat="server">

            public class StaticParams : SerializableContextBase {

                public StaticParams(Context context): base(context) {
                    KalendModule kalend = KalendModule.GetInstance(this);
                    PlaceModule place = PlaceModule.GetInstance(this);
                    if (urlopOjcowski == null)
                        urlopOjcowski = kalend.DefNieobecnosci[new Guid("00000000-0006-0005-0038-000000000000")];
                    if (urlopMacierzynski == null)
                        urlopMacierzynski = new DefinicjaNieobecnosci[] {
                            kalend.DefNieobecnosci[new Guid("00000000-0006-0005-0040-000000000000")],
                            kalend.DefNieobecnosci[new Guid("00000000-0006-0005-0044-000000000000")],
                            kalend.DefNieobecnosci[new Guid("00000000-0006-0005-0045-000000000000")] };
                    if (ekwiwalentUrlop == null)
                        ekwiwalentUrlop = place.DefElementow[new Guid("00000000-0007-0002-0074-000000000000")];
                    if (ekwiwalentUrlopDodatkowy == null)
                        ekwiwalentUrlopDodatkowy = place.DefElementow[new Guid("00000000-0007-0002-0156-000000000000")];
                }

                bool wychowJakoBezskładkowy = false;
                [Priority(10)]
                [Caption("Wychow.jako bezskładk.")]
                public bool WychowJakoBezskładkowy {
                    get { return wychowJakoBezskładkowy; }
                    set {
                        wychowJakoBezskładkowy = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                bool bezplatnyJakoBezskładkowy = false;
                [Priority(20)]
                [Caption("Bezpłatn.jako bezskładk.")]
                public bool BezplatnyJakoBezskładkowy {
                    get { return bezplatnyJakoBezskładkowy; }
                    set {
                        bezplatnyJakoBezskładkowy = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                DefinicjaElementu zajęcieKomornicze;
                [Priority(30)]
                [Caption("Nazwa zaj.komornicz.")]
                public DefinicjaElementu ZajęcieKomornicze {
                    get { return zajęcieKomornicze; }
                    set {
                        zajęcieKomornicze = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                public object GetListZajęcieKomornicze() {
                    return DefElementow.Elementy(this, RodzajŹródłaWypłaty.Dodatek);
                }
                
                DefinicjaNieobecnosci urlopOjcowski;
                [Priority(40)]
                [Caption("Urlop ojcowski")]
                public DefinicjaNieobecnosci UrlopOjcowski {
                    get { return urlopOjcowski; }
                    set {
                        urlopOjcowski = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                public object GetListUrlopOjcowski() {
                    return DefNieobecnosci.AktywneDefinicje(this);
                }

                bool pelneStanowisko = false;
                [Priority(50)]
                [Caption("Stanowisko pełna nazwa")]
                public bool PelneStanowisko {
                    get { return pelneStanowisko; }
                    set {
                        pelneStanowisko = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                DefinicjaNieobecnosci[] urlopMacierzynski;
                [Priority(60)]
                [Caption("Urlop wych(zas.macierz)")]
                public DefinicjaNieobecnosci[] UrlopMacierzynski {
                    get { return urlopMacierzynski; }
                    set {
                        urlopMacierzynski = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                public object GetListUrlopMacierzynski() {
                    return DefNieobecnosci.AktywneDefinicje(this);
                }

                bool wypoczynkowyZDodatkowym = false;
                [Priority(70)]
                [Caption("Url.dod. z url.wyp.")]
                public bool WypoczynkowyZDodatkowym {
                    get { return wypoczynkowyZDodatkowym; }
                    set {
                        wypoczynkowyZDodatkowym = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                bool objasnienia = true;
                [Priority(80)]
                [Caption("Objaśnienia punktów")]
                public bool Objasnienia {
                    get { return objasnienia; }
                    set {
                        objasnienia = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                bool pkt49 = true;
                [Priority(90)]
                [Caption("Pkt.4.9 szczegółowo")]
                public bool Pkt49 {
                    get { return pkt49; }
                    set {
                        pkt49 = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                DefinicjaElementu odprawa;
                [Priority(100)]
                [Caption("Odprawa emer-rent")]
                public DefinicjaElementu Odprawa {
                    get { return odprawa; }
                    set {
                        odprawa = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                public object GetListOdprawa() {
                    return DefElementow.Elementy(this, RodzajŹródłaWypłaty.Dodatek);
                }

                DefinicjaElementu ekwiwalentUrlop;
                [Priority(110)]
                [Caption("Ekwiwalent za urlop")]
                public DefinicjaElementu EkwiwalentUrlop {
                    get { return ekwiwalentUrlop; }
                    set {
                        ekwiwalentUrlop = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                public object GetListEkwiwalentUrlop() {
                    return DefElementow.Elementy(this, RodzajŹródłaWypłaty.Dodatek);
                }

                DefinicjaElementu ekwiwalentUrlopDodatkowy;
                [Priority(120)]
                [Caption("Ekwiwalent za url.dod.")]
                public DefinicjaElementu EkwiwalentUrlopDodatkowy {
                    get { return ekwiwalentUrlopDodatkowy; }
                    set {
                        ekwiwalentUrlopDodatkowy = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                public object GetListEkwiwalentUrlopDodatkowy() {
                    return DefElementow.Elementy(this, RodzajŹródłaWypłaty.Dodatek);
                }
            }

            [SettingsContext]
            public StaticParams StaticPars {
                set {
                    odprawa = value.Odprawa;
                    zajęcieKomornicze = value.ZajęcieKomornicze;
                    urlopOjcowski = value.UrlopOjcowski;
                    urlopMacierzynski = value.UrlopMacierzynski;
                    ekwiwalentUrlop = value.EkwiwalentUrlop;
                    ekwiwalentUrlopDodatkowy = value.EkwiwalentUrlopDodatkowy;
                    wychowJakoBezskładkowy = value.WychowJakoBezskładkowy;
                    bezplatnyJakoBezskładkowy = value.BezplatnyJakoBezskładkowy;
                    pelneStanowisko = value.PelneStanowisko;
                    wypoczynkowyZDodatkowym = value.WypoczynkowyZDodatkowym;
                    objasnienia = value.Objasnienia;
                    pkt49 = value.Pkt49;
                }
            }

            DefinicjaElementu odprawa = null;
            DefinicjaElementu zajęcieKomornicze = null;
            DefinicjaNieobecnosci urlopOjcowski = null;
            DefinicjaNieobecnosci[] urlopMacierzynski = null;
            DefinicjaElementu ekwiwalentUrlop = null;
            DefinicjaElementu ekwiwalentUrlopDodatkowy = null;
            bool wychowJakoBezskładkowy = false;
            bool bezplatnyJakoBezskładkowy = false;
            bool pelneStanowisko = false;
            bool wypoczynkowyZDodatkowym = false;
            bool objasnienia = true;
            bool pkt49 = true;
            static readonly string dots = "nie dotyczy";

            public class _Info : ContextBase {
                public _Info(Context context) : base(context) {
                    naDzien = ((ActualDate)context[typeof(ActualDate)]).Actual;
                }

                Date naDzien;
                [Priority(1)]
                [Caption("Na dzień")]
                public Date NaDzien {
                    get { return naDzien; }
                    set {
                        naDzien = value;
                        OnChanged(EventArgs.Empty);
                    }
                }
                
                int iloscKopii = 1;
                [Priority(2)]
                [Caption("Ilość kopii")]
                public int IloscKopii {
                    get { return iloscKopii; }
                    set {
                        if (value <= 0)
                            value = 1;
                        iloscKopii = value;
                        OnChanged(EventArgs.Empty);
                    }
                }
            }

            _Info info;
            [Context]
            public _Info Info {
                set { info = value; }
            }
                     
    /*
    W urlopie wypoczynkowym uwzględniamy:
    Wszystkie urlopy z aktualnego roku kalendarzowego
		minus przeniesienie na 1 stycznia (o ile jest tam limit)
		minus ekwiwialeny za czas urlopu (ponad przeniesienie na 1 stycznia)*/

    class OkresyNieobecnosci {
        string okres;
        public string Okres {
            get { return okres; }
            set { okres = value; }
        }
        string nazwa;
        public string Nazwa {
            get { return nazwa; }
            set { nazwa = value; }
        }
    }

    bool GetUrlopMacierzynski(DefinicjaNieobecnosci def) {
        foreach (DefinicjaNieobecnosci dn in urlopMacierzynski)
            if (dn == def) return true;
        return false;
    }
    
    string GetNazwa(OkresNieobecności n) {
        string nazwa = string.Empty;
        if (n != null)
            nazwa = (n.Definicja.Przyczyna == PrzyczynaNieobecnosci.UrlopWychowawczy ||
                GetUrlopMacierzynski(n.Definicja) ? "Urlop wychowawczy" : n.Definicja.Nazwa) +
                (n.Definicja.Guid == new Guid("00000000-0006-0005-0030-000000000000") ? " - " +
                CaptionAttribute.EnumToString(n.Zwolnienie.Przyczyna) : "");
        return nazwa;
    }

    string koniec = "nadal";
    
    void OnContextLoad(Object sender, EventArgs args) {
        PracHistoria historia = (PracHistoria)dc[typeof(PracHistoria)];
        Pracownik pracownik = historia.Pracownik;
        report = ReportHeader1;
        labelMiejscowosc.EditValue = GetMiejscowosc(historia);
        labelData.EditValue = info.NaDzien.ToString();
            
        FromTo okresZatrudnienia = historia.Etat.OkresZatrudnienia;
        
        KadryModule module = KadryModule.GetInstance(dc);
        sadpracy.EditValue = module.Config.Wydruki.SądPracy.Length > 0 ?
            module.Config.Wydruki.SądPracy : "Sądu Rejonowego - Sądu Pracy w ..............................";
            
        string s = "";
        string last = "";
        string firma = "";
        Date data = Date.Empty;
        Periods okresy = Periods.Empty;
        foreach (PracHistoria ph in pracownik.Historia.GetIntersectedRows(okresZatrudnienia)) {
            if (last != GetStanowisko(ph)) {
                last = GetStanowisko(ph);
                if (s == "")
                    s = "<strong><LI>" + last;
                else {
                    s += " </strong>od<strong> " + okresy.From + " </strong>do<strong> " + (okresy.To != Date.MaxValue ? okresy.To.ToString() : koniec) + "</strong><LI><strong>"+last;
                    okresy = Periods.Empty;
                }
            }
            okresy += ph.Etat.EfektywnyOkres;
            if (data == Date.Empty)
                data = ph.Etat.Okres.From;
            if (ph.Etat.DataPrzejeciaPracownika != Date.Empty && ph.Etat.DataPrzejeciaPracownika != data && ph.Etat.EfektywnyOkres.Contains(ph.Etat.DataPrzejeciaPracownika)) {
                if (firma != "")
                    firma += "<br/>";
                firma += string.Format("<strong>{0}</strong> w okresie od <strong>{1}</strong> do <strong>{2}</strong> (przejście w trybie art. 23' KP)",
                    ph.Etat.PoprzedniPracodawca,
                    data,
                    ph.Etat.DataPrzejeciaPracownika.AddDays(-1));
                data = ph.Etat.DataPrzejeciaPracownika;
            }
        }
        if (firma != "")
            firma += string.Format("<br/><strong>{0}</strong> w okresie od <strong>{1}</strong> do <strong>{2}</strong>",
                DaneFirmy(historia),
                data,
                (okresZatrudnienia.To != Date.MaxValue ? okresZatrudnienia.To.ToString() : koniec));
        else
            firma = string.Format("<strong>{0}</strong> w okresie od <strong>{1}</strong> do <strong>{2}</strong>",
                DaneFirmy(historia),
                okresZatrudnienia.From,
                (okresZatrudnienia.To != Date.MaxValue ? okresZatrudnienia.To.ToString() : koniec));
    
        if (okresy != Periods.Empty)
            s += " </strong>od<strong> " + okresy.From + " </strong>do<strong> " + (okresy.To != Date.MaxValue ? okresy.To.ToString() : koniec) + "</strong>";

        ArrayList wymiary = new ArrayList();
        Fraction currw = historia.Etat.Wymiar;
        Fraction lastw = Fraction.Zero;
        FromTo efektywny = FromTo.Empty;
        okresy = Periods.Empty;
        foreach (PracHistoria ph in pracownik.Historia.GetIntersectedRows(okresZatrudnienia)) {
            efektywny = ph.Etat.EfektywnyOkres;
            ZbiegPracyIRodzicielstwa zpr = (efektywny.To != Date.MaxValue) ? (ZbiegPracyIRodzicielstwa)pracownik.ZbiegiPracyIRodzicielstwa[efektywny.To] : null;
            currw = (zpr != null) ? zpr.WymiarEtatu : ph.Etat.Wymiar;
            if (lastw != currw) {
                if (okresy != Periods.Empty)
                    wymiary.Add(new DictionaryEntry(lastw, okresy));
                lastw = currw;
                okresy = Periods.Empty;
            }
            okresy += efektywny;
        }

        if (okresy != Periods.Empty)
            wymiary.Add(new DictionaryEntry(lastw, okresy));

        string wymiar = "";
        if (wymiary.Count < 2)
            wymiar = "<strong>" + currw + "</strong> etatu.<br/>";
        else {
            string ss = "";
            foreach (DictionaryEntry de in wymiary) {
                Periods pe = (Periods)de.Value;
                ss += "<li><strong>" + (Fraction)de.Key + "</strong> etatu od <strong>" + pe.From + "</strong> do <strong>" + (pe.To != Date.MaxValue ? pe.To.ToString() : koniec) + "</strong></li>";
            }
            wymiar = ss;
        }
        
        labelZatrudnienie.EditValue = string.Format("{0}<br/>w wymiarze: {1}", firma, wymiar);
        labelStanowisko.EditValue = s;
        labelPrzyczyna.EditValue = "<li>" + historia.Etat.PrzyczynaRozwUmowy;
    
        FromTo okres = historia.Etat.Okres.To != Date.MaxValue ? FromTo.Year(historia.Etat.Okres.To.Year) * okresZatrudnienia : okresZatrudnienia;
    
        string urlojc = "";
        Periods wych = Periods.Empty;
        Periods dniNieWyn = Periods.Empty;

        bool op188cz = false;
        int op188 = 0;
        Time op188T = Time.Zero;
        Periods sw = Periods.Empty;
        Time wyp = Time.Zero;
        Time wyp167 = Time.Zero;
        int dni167 = 0;
        Time dod = Time.Zero;
        
        ArrayList okresyBezpłatne = new ArrayList();
        foreach (OkresNieobecności n in pracownik.Czasy.Nieobecnosci(okresZatrudnienia, true)) {
            switch (n.Definicja.Przyczyna) {
                case PrzyczynaNieobecnosci.UrlopBezpłatny:
                case PrzyczynaNieobecnosci.UsprawiedliwionaNiepłatna:
                    if (n.Definicja.Guid != new Guid("00000000-0006-0005-0008-000000000000")) {
                        OkresyNieobecnosci on = new OkresyNieobecnosci();
                        on.Okres = n.Okres.ToString();
                        on.Nazwa = n.Definicja.Nazwa;
                        okresyBezpłatne.Add(on);
                    }
                    break;
                case PrzyczynaNieobecnosci.UrlopWychowawczy:
                    wych += n.Okres;
                    break;
                case PrzyczynaNieobecnosci.SłużbaWojskowa:
                    sw += n.Okres;
                    break;
                default:
                    if (n.Definicja == urlopOjcowski) {          //TID: 8461
                        if (urlojc == "")
                            urlojc = n.Definicja.Nazwa + " w wymiarze:";
                        else
                            urlojc += ",";
                        urlojc += " <strong>" + n.Okres.Days + "</strong> dni (" + n.Okres + ")";
                    }
                    else if (GetUrlopMacierzynski(n.Definicja))
                        wych += n.Okres;
                    break;
            }
        }

        Grid2.DataSource = okresyBezpłatne;
        if (okresyBezpłatne.Count == 0) {
            urlopbezplatny.EditValue = dots;
            Grid2.Visible = false;
        }
        else {
            urlopbezplatny.EditValue = "";
            Grid2.Visible = true;
        }
        
        foreach (OkresNieobecności n in pracownik.Czasy.Nieobecnosci(okres, true)) {
            switch (n.Definicja.Przyczyna) {
                case PrzyczynaNieobecnosci.UrlopBezpłatny:
                    break;
                case PrzyczynaNieobecnosci.UrlopWychowawczy:
                    break;
                case PrzyczynaNieobecnosci.UrlopWypoczynkowy:
                    if (n.Urlop.Przyczyna == PrzyczynaUrlopu.NaŻądanie) {
                        CzasDni cd = n.Norma(n.Okres);
                        wyp167 += cd.Czas;
                        dni167 += cd.Dni;
                    }
                    else
                        wyp += n.Norma(n.Okres).Czas;
                    break;
                default:
                    if (n.Definicja != urlopOjcowski) {
                        DefinicjaLimitu l = n.Definicja.Limit;
                        if (l != null)
                            if (l.Guid == new Guid("00000000-0006-0004-0003-000000000000"))
                                { op188 += n.Norma(n.Okres).Dni; op188cz = false; }
                            else if (l.Guid == new Guid("00000000-0006-0004-0005-000000000000"))
                                { op188T += n.Norma(n.Okres).Czas; op188cz = true; }
                            else if (l.Guid == DefinicjaLimitu.UrlopDodatkowy)
                                dod += n.Norma(n.Okres).Czas;
                    }
                    break;
            }
        }

        Periods okresyWyczekiwania = Periods.Empty;
        try {
            foreach (WypElement e in pracownik.Elementy[okresZatrudnienia])
                if (e.Definicja.Guid == DefinicjaElementu.WynagrChoroboweZerowe) {
                    if (e.RodzajZrodla == RodzajŹródłaWypłaty.Storno)
                        dniNieWyn -= e.Okres;
                    else
                        dniNieWyn += e.Okres;
                }
                else if (e.Definicja.Guid == DefinicjaElementu.OkresWyczekiwania) {
                    if (e.RodzajZrodla == RodzajŹródłaWypłaty.Storno)
                        okresyWyczekiwania -= e.Okres;
                    else
                        okresyWyczekiwania += e.Okres;
                }
        }
        catch { Msg(); }

        okresyWyczekiwania = okresyWyczekiwania.ToFlat();

        string currNazwa = string.Empty;
        string prevNazwa = string.Empty;
        FromTo prevOkr = FromTo.Empty;
        OkresNieobecności prevDef = null;
        ArrayList okresyNieskładkowe = new ArrayList();
        Periods okresyZatrudnienia = (Periods.New(okresZatrudnienia) - okresyWyczekiwania).ToFlat();
        foreach (FromTo okrzatr in okresyZatrudnienia)
            foreach (OkresNieobecności n in pracownik.Czasy.Nieobecnosci(okrzatr, true)) {
                currNazwa = GetNazwa(n);
                switch (n.Definicja.Przyczyna) {
                    case PrzyczynaNieobecnosci.UrlopRehabilitacyjny:
                    case PrzyczynaNieobecnosci.UrlopOpiekuńczy:
                    case PrzyczynaNieobecnosci.ZwolnienieChorobowe:
                    case PrzyczynaNieobecnosci.UrlopWychowawczy:        //TID: 8565
                    case PrzyczynaNieobecnosci.UrlopWychowawczyZUS:
                        //TID: 5982
                    case PrzyczynaNieobecnosci.UrlopBezpłatny:
                        //TID: 8565
                        if ((n.Definicja.Przyczyna != PrzyczynaNieobecnosci.UrlopWychowawczy || wychowJakoBezskładkowy) &&
                            (n.Definicja.Guid != new Guid("00000000-0006-0005-0018-000000000000") || bezplatnyJakoBezskładkowy)) {
                            if (prevDef != null && prevNazwa == currNazwa &&
                                prevDef.Zwolnienie.Przyczyna == n.Zwolnienie.Przyczyna &&
                                prevOkr.To + 1 == n.Okres.From)
                                prevOkr = new FromTo(prevOkr.From, n.Okres.To);
                            else {
                                if (prevDef != null) {
                                    OkresyNieobecnosci on = new OkresyNieobecnosci();
                                    on.Okres = prevOkr.ToString();
                                    on.Nazwa = GetNazwa(prevDef);
                                    okresyNieskładkowe.Add(on);
                                }
                                prevNazwa = GetNazwa(n);
                                prevOkr = n.Okres;
                                prevDef = n;
                            }
                        }
                        break;
                    default:
                        if (GetUrlopMacierzynski(n.Definicja) && wychowJakoBezskładkowy) {
                            if (prevDef != null && prevNazwa == currNazwa &&
                                prevDef.Zwolnienie.Przyczyna == n.Zwolnienie.Przyczyna &&
                                prevOkr.To + 1 == n.Okres.From)
                                prevOkr = new FromTo(prevOkr.From, n.Okres.To);
                            else {
                                if (prevDef != null) {
                                    OkresyNieobecnosci on = new OkresyNieobecnosci();
                                    on.Okres = prevOkr.ToString();
                                    on.Nazwa = GetNazwa(prevDef);
                                    okresyNieskładkowe.Add(on);
                                }
                                prevNazwa = GetNazwa(n);
                                prevOkr = n.Okres;
                                prevDef = n;
                            }
                        }
                        break;
                }
            }

        if (prevDef != null) {
            OkresyNieobecnosci on = new OkresyNieobecnosci();
            on.Okres = prevOkr.ToString();
            on.Nazwa = GetNazwa(prevDef);
            okresyNieskładkowe.Add(on);
        }

        Grid1.DataSource = okresyNieskładkowe;
        if (okresyNieskładkowe.Count == 0) {
            okresyNS.EditValue = "<strong>0</strong> dni";
            Grid1.Visible = false;
        }
        else
            Grid1.Visible = true;
        
        Time norma = pracownik[okres.To].Etat.Kalendarz.NormaDobowa;
        if (norma==Time.Zero)
            norma = new Time(8, 0);
            
        Time przeniesWyp = WyliczPrzeniesUrlop(pracownik, okres);        
        Time ekwiwalentWyp = WyliczEkwiwalentUrlop(pracownik, okres);
        Time ekwiwalentWyp2;
        UpdateWyp(ref wyp, out ekwiwalentWyp2, przeniesWyp, ekwiwalentWyp);

        Time przeniesDod = WyliczPrzeniesDodatkowy(pracownik, okres);
        Time ekwiwalentDod = WyliczEkwiwalentDodatkowy(pracownik, okres);
        Time ekwiwalentDod2;
        UpdateWyp(ref dod, out ekwiwalentDod2, przeniesDod, ekwiwalentDod);
                
        wychowawczy.EditValue = wych==Periods.Empty ? dots : wych.ToFlat().ToString("c");
        opieka188.EditValue = (op188cz ? op188T + " </strong>godz." : op188 + " </strong>dni");
        opieka188opis.EditValue = "(liczba " + (op188cz ? "godz." : "dni") + " zwolnienia wykorzystanego w roku kalendarzowym, w którym ustał stosunek pracy)";

        int dniWyp = Dni(wyp + wyp167, norma);
        //TID: 8353
        if (dniWyp < dni167) {
            wypoczynkowy.EditValue = dni167 + (wypoczynkowyZDodatkowym ? Dni(dod, norma) : 0);
            wypoczynkowyT.EditValue = "";
        }
        else {
            wypoczynkowy.EditValue = dniWyp + (wypoczynkowyZDodatkowym ? Dni(dod, norma) : 0);
            wypoczynkowyT.EditValue = Godz(wyp + wyp167, norma);
        }
        wypoczynkowyG.EditValue = wyp + wyp167 + (wypoczynkowyZDodatkowym ? dod : Time.Zero);
        ekwiwalentG.EditValue = ekwiwalentWyp2 == Time.Zero ? "" : ", w tym <strong>" + ekwiwalentWyp2 + "</strong> godz. ekwiwalentu za czas urlopu";
        wypoczynkowy167.EditValue = dni167;
        wypoczynkowy167G.EditValue = wyp167;
        służba.EditValue = sw==Periods.Empty ? dots : sw.ToFlat().ToString("c");

        string szWarH = SzczególneWarunkiHist(pracownik, okresZatrudnienia);
        string szWarU = SzczególneWarunkiUbezp(pracownik, okresZatrudnienia);
		if ((szWarH.Length == 0) && (szWarU.Length == 0))
			szWarunki.EditValue = dots;
		else {
			szWarunki.EditValue = szWarH;
			if ((szWarH.Length > 0) && (szWarU.Length > 0))
				szWarunki.EditValue += ", ";
			szWarunki.EditValue += szWarU;
		}

        if ((dod == Time.Zero) && (urlojc == "") && (ekwiwalentDod2==Time.Zero))
            dodUrlop.EditValue = "<strong>0</strong> dni";
        else {
            string tmp = "";
            if (pkt49) {
                if (dod != Time.Zero) {
                    tmp += "urlop dodatkowy <strong>" + Dni(dod, norma) + "</strong> dni";
                    if (ekwiwalentDod2 != Time.Zero)            //TID: 10365
                        tmp += " (w tym wypłacony ekwiwalent <strong>" + Dni(ekwiwalentDod2, norma) + "</strong> dni)";
                }
                if (urlojc != "") {
                    if (tmp != "")
                        tmp += ", ";
                    tmp += urlojc;
                }
            }
            else {
                if (dod != Time.Zero)
                    tmp += "<b>udzielono dodatkowego urlopu wypoczynkowego na podstawie art. 19 ustawy z dnia 27 sierpnia 1997 r. o rehabilitacji zawodowej i społecznej oraz zatrudnianiu osób niepełnosprawnych (Dz. U. z 2011 r. nr 127, poz. 721 z późn. zm.).</b>";
                if (urlojc != "") {
                    if (tmp != "")
                        tmp += ", ";
                    tmp += "<b>udzielono urlopu ojcowskiego na podstawie art. 182<sup>3</sup> ustawy z dnia 26.06.1974 r. Kodeks pracy (Dz. U. z 1998 r. nr 21, poz. 94).</b>";
                }
            }
            dodUrlop.EditValue = tmp;
        }

        if (dniNieWyn.Count == 0)
            nieWyn.EditValue = dots;
        else {
            string ss = "";
            foreach (FromTo odn in dniNieWyn) {
                if (ss != "")
                    ss += ", ";
                if (odn.Days == 1)
                    ss += odn.From;
                else
                    ss += odn;
            }
            nieWyn.EditValue = ss;
        }

        Set<string> zajęcia = new Set<string>();
        string zz = "";
        foreach (ZajęcieKomornicze zk in pracownik.ZajęciaKomornicze) {
            if (zk.SplataZakonczona || zk.Anulowane)
                continue;
            if (zk.Data > okresZatrudnienia.To ||
                (zk.Rodzaj == RodzajeZajęciaWynagrodzenia.KwotaMiesięczna && zk.DataSplaty != Date.MaxValue))
                continue;
            decimal splata = 0;
            try {
                foreach (WypElement w in zk.Elementy)
                    if (w.Okres.From <= okresZatrudnienia.To)
                        splata += -w.Wartosc;
            }
            catch { Msg(); }
            if (zk.Rodzaj == RodzajeZajęciaWynagrodzenia.Kwota && zk.Kwota <= splata)
                continue;
            if (zk.Rozliczenie.Odbiorca == null)
                throw new Exception(string.Format("W zajęciu wynagrodzenia nr: {0} brak uzupełnionego pola Komornik", zk.NumerSprawy));
            string zks = zk.Rozliczenie.Odbiorca.Nazwa;
            if (zk.NumerSprawy.Length > 0)
                zks += ", ";
            zks += "<strong>" + zk.NumerSprawy + "</strong>";
            zks += ", wysokość potrąconych już kwot: <strong>" + splata + "</strong>";
            zajęcia.Add(zks);
        }
        if (zajęcieKomornicze != null) {
            decimal we = 0;
            try {
                foreach (WypElement e in pracownik.Elementy[okresZatrudnienia])
                    if (e.Definicja == zajęcieKomornicze)
                        we += System.Math.Abs(e.Wartosc);                
            }
            catch { Msg(); }
            if (we != 0) {
                string zks = zajęcieKomornicze.Nazwa + ", <strong>" + we + "</strong>";
                zajęcia.Add(zks);
            }
        }        
        foreach (string z in zajęcia)
            zz += "<li>" + z + "</li>";
        komornik.EditValue = zz == "" ? "<strong>" + dots + "</strong>" : zz;

        if (odprawa != null) {
            try {
                foreach (WypElement e in pracownik.Elementy[okresZatrudnienia])
                    if (e.Definicja == odprawa) {
                        dodUrlop.EditValue += "<br/><li><b>wypłacono odprawę emerytalno-rentową przewidzianą w art. 92<sup>1</sup> K.p</b></li>";
                        break;
                    }
            }
            catch { Msg(); }
        }        
        
        double pozostDni = 0;
        Time pozostGodz = Time.Zero;
        WyliczPozostalo(pracownik, okres, ref pozostDni, ref pozostGodz);
        if (pozostDni > 0 || pozostGodz > Time.Zero)
            dodatkowe.EditValue = string.Format("</strong>Strony skorzystały z możliwości wynikającej z art. 171 § 3 KP i postanowiły" +
                " o wykorzystaniu <strong>{0}</strong> dni (<strong>{1}</strong> godz.) urlopu wypoczynkowego w czasie kolejnego zawartego miedzy nimi stosunku pracy.",
                pozostDni, pozostGodz);
        else
            dodatkowe.EditValue = dots;
    
        if (historia.Etat.OkresWypowiedzenia.Skrocony && historia.Etat.OkresWypowiedzenia.Uplywa>historia.Etat.Okres.To)
            skrOkres.EditValue = new FromTo(historia.Etat.Okres.To+1, historia.Etat.OkresWypowiedzenia.Uplywa);
        else
            skrOkres.EditValue = dots;
    
        PlaceModule płace = PlaceModule.GetInstance(pracownik);
        SubTable es = new SubTable(płace.WypElementy.WgPracownik[pracownik], okres);
    
        int wyn92 = 0;
        List<FromTo> wyn92ft = new List<FromTo>();
        foreach (WypElement element in es) {
            try {
                if (!wyn92ft.Contains(element.Okres) || element is WypElementStorno)
                    if (!element.RozliczenieStorna && !element.KorektaWyrokTK) {
                        KodRSA rsa = element.KodRSA;
                        if (rsa != null && rsa.WynagrodzenieChorobowe) {
                            WypSkladnikGłówny sg = element.SkładnikGłówny;
                            if (sg != null) {
                                wyn92 += sg.Dni;
                                if (element is WypElementStorno)
                                    wyn92ft.Remove(element.Okres);
                                else
                                    wyn92ft.Add(element.Okres);
                            }
                        }
                    }
            }
            catch { Msg(); }
        }
    
        wynagrodz92.EditValue = wyn92;

        desc1.Visible = desc2.Visible = desc3.Visible = desc4.Visible = desc5.Visible = desc6.Visible =
            desc7.Visible = desc8.Visible = desc9.Visible = desc10.Visible = desc11.Visible = desc12.Visible = objasnienia;

        ArrayList al = new ArrayList();
        for (int i = 0; i < info.IloscKopii; i++)
            al.Add(historia);
        DataRepeater1.DataSource = al;
    }

    string GetStanowisko(PracHistoria ph) {
        string stanowiskoPelne = "";
        if (pelneStanowisko)
            stanowiskoPelne = ph.Etat.StanowiskoPełne;
        if (stanowiskoPelne.Length == 0)
            stanowiskoPelne = ph.Etat.Stanowisko;
        return stanowiskoPelne;
    }

    string GetMiejscowosc(PracHistoria ph) {
        CoreModule core = CoreModule.GetInstance(dc);
        string miejscowosc = ReportHeader.GetPieczątka(dc).Adres.Miejscowosc;
        if (miejscowosc.Length == 0)
            miejscowosc = core.Config.Firma.AdresSiedziby.Miejscowosc;
        if (ph.Etat.Wydzial != null && ph.Etat.Wydzial.Oddzial != null) {
            OddzialFirmy of = ph.Etat.Wydzial.Oddzial;
            if (!string.IsNullOrEmpty(of.Adres.Miejscowosc)) miejscowosc = of.Adres.Miejscowosc;
        }                
        return miejscowosc;
    }
    
    string DaneFirmy(PracHistoria ph) {
        CoreModule core = CoreModule.GetInstance(dc);
        string nazwa = core.Config.Firma.Pieczątka.Nazwa;
        string regon = core.Config.Firma.Pieczątka.REGON;
        if (ph.Etat.Wydzial != null && ph.Etat.Wydzial.Oddzial != null) {
            OddzialFirmy of = ph.Etat.Wydzial.Oddzial;
            if (!string.IsNullOrEmpty(of.Nazwa)) nazwa = of.Nazwa;
            if (!string.IsNullOrEmpty(of.Deklaracje.REGON)) regon = of.Deklaracje.REGON;
        }
        PieczątkaREGON.EditValue = regon;

        return nazwa;
    }

    void Grid1_BeforeRow(Object sender, RowEventArgs args) {
        OkresyNieobecnosci on = (OkresyNieobecnosci)args.Row;
        FromTo okres = FromTo.Parse(on.Okres);
        col1OkresOd.EditValue = okres.From;
        col1OkresDo.EditValue = okres.To;
        col1Nazwa.EditValue = on.Nazwa;
    }

    void Grid2_BeforeRow(Object sender, RowEventArgs args) {
        OkresyNieobecnosci on = (OkresyNieobecnosci)args.Row;
        FromTo okres = FromTo.Parse(on.Okres);
        col2OkresOd.EditValue = okres.From;
        col2OkresDo.EditValue = okres.To;
        col2Nazwa.EditValue = on.Nazwa;
    }
    
            string SzczególneWarunkiHist(Pracownik pracownik, FromTo okresZatrudnienia) {
                string result = "";
                FromTo okres = FromTo.Empty;
                string stanowisko = "";
				string kod = "";
                
                foreach (PracHistoria ph in pracownik.Historia.GetIntersectedRows(okresZatrudnienia))
                    if (ph.PracaWSzczWarunkach.KodStr != "" || ph.PracaWSzczWarunkach.Opis != "") {
                        FromTo o = ph.PracaWSzczWarunkach.OkresExt * ph.Etat.EfektywnyOkres;
                        if (o != FromTo.Empty) {
                            if (okres.To + 1 == o.From && stanowisko == GetStanowisko(ph))
                                okres = new FromTo(okres.From, o.To);
                            else {
                                if (okres != FromTo.Empty) {
                                    if (result != "")
                                        result += ", ";
                                    result += okres + " (" + kod + ", " + stanowisko + ")";
                                }
                                okres = o;
								kod = ph.PracaWSzczWarunkach.KodStr != "" ? ph.PracaWSzczWarunkach.KodStr : ph.PracaWSzczWarunkach.Opis;
                                stanowisko = GetStanowisko(ph);
                            }
                        }
                    }
                
                if (okres != FromTo.Empty) {
                    if (result != "")
                        result += ", ";
                    result += okres + " (" + kod + ", " + stanowisko + ")";
                }

                return result;
            }

            string SzczególneWarunkiUbezp(Pracownik pracownik, FromTo okresZatrudnienia) {
                string result = "";
                FromTo okres = FromTo.Empty;
                string stanowisko = "";
                string kod = "";
                                
                foreach (PracHistoria ph in pracownik.Historia.GetIntersectedRows(okresZatrudnienia))
                    if (ph.PracaWSzczWarunkach2009.Kod != null) {
                        FromTo o = ph.PracaWSzczWarunkach2009.Okres * ph.Etat.EfektywnyOkres;
                        if (o != FromTo.Empty) {
                            if (okres.To + 1 == o.From && stanowisko == GetStanowisko(ph))
                                okres = new FromTo(okres.From, o.To);
                            else {
                                if (okres != FromTo.Empty) {
                                    if (result != "")
                                        result += ", ";
                                    result += okres + " (Kod: " + kod + ", " + stanowisko + ")";
                                }
                                okres = o;
                                kod = ph.PracaWSzczWarunkach2009.Kod.Nazwa;
                                stanowisko = GetStanowisko(ph);
                            }
                        }
                    }

                if (okres != FromTo.Empty) {
                    if (result != "")
                        result += ", ";
                    result += okres + " (Kod: " + kod + ", " + stanowisko + ")";
                }

                return result;
            }
		                                                                                
            //1. Wypłacony urlop najpierw traktujemy jako zaległy, czyli
            //pomniejszamy obie te liczby o mniejszą z nich.
	//2. Wypłacony ekwiwalent traktujemy najpier jako ekwiwalent za poprzedni rok, czyli
	//pomniejszamy obie te liczby o mniejszą z nich.
	//3. Pomniejszamy urlop o to co pozostało z przeniesienia.
	//4. Powiększamy urlop o to co zostało z ekwiwalentu.
            void UpdateWyp(ref Time wyp, out Time ekwg, Time przenies, Time ekwiwalent) {
                if (przenies >= wyp) {
                    przenies -= wyp;
                    wyp = Time.Zero;
                }
                else {
                    wyp -= przenies;
                    przenies = Time.Zero;
                }

                if (przenies >= ekwiwalent) {
                    przenies -= ekwiwalent;
                    ekwiwalent = Time.Zero;
                }
                else {
                    ekwiwalent -= przenies;
                    przenies = Time.Zero;
                }

                /*if (wyp >= przenies)
                    wyp -= przenies;
                else
                    wyp = Time.Zero;*/

                wyp += ekwiwalent;
                ekwg = ekwiwalent;
            }

            Time WyliczPrzeniesUrlop(Pracownik pracownik, FromTo okres) {
                KalendModule kalend = KalendModule.GetInstance(pracownik);
                DefinicjaLimitu def = kalend.DefinicjeLimitow.UrlopWypoczynkowy;
                return WyliczPrzenies(pracownik, okres, def);
            }

            Time WyliczPrzeniesDodatkowy(Pracownik pracownik, FromTo okres) {
                KalendModule kalend = KalendModule.GetInstance(pracownik);
                DefinicjaLimitu def = kalend.DefinicjeLimitow.UrlopDodatkowy;
                return WyliczPrzenies(pracownik, okres, def);
            }

            Time WyliczPrzenies(Pracownik pracownik, FromTo okres, DefinicjaLimitu def) {
                if (okres.From != new Date(okres.From.Year, 1, 1))
                    return Time.Zero;

                LimitNieobecnosci limit = def[pracownik, okres.From, false];
                if (limit == null)
                    return Time.Zero;

                Time t = limit.PrzeniesienieGodz;
                return t == Time.Empty ? Time.Zero : t;
            }

            void WyliczPozostalo(Pracownik pracownik, FromTo okres, ref double dni, ref Time godz) {
                KalendModule kalend = KalendModule.GetInstance(pracownik);
                DefinicjaLimitu def = kalend.DefinicjeLimitow.UrlopWypoczynkowy;

                LimitNieobecnosci limit = def[pracownik, okres.To, false];
                if (limit == null)
                    return;

                dni = limit.PozostaloDni;
                godz = limit.PozostaloGodz;
            }
            
    Time WyliczEkwiwalentUrlop(Pracownik pracownik, FromTo okres) {
        return ekwiwalentUrlop != null ? WyliczEkwiwalent(pracownik, okres, ekwiwalentUrlop.Guid) : Time.Zero;
    }

    Time WyliczEkwiwalentDodatkowy(Pracownik pracownik, FromTo okres) {
        return ekwiwalentUrlopDodatkowy != null ? WyliczEkwiwalent(pracownik, okres, ekwiwalentUrlopDodatkowy.Guid) : Time.Zero;
    }

    Time WyliczEkwiwalent(Pracownik pracownik, FromTo okres, Guid guid) {
		Time t = Time.Zero;
		PlaceModule płace = PlaceModule.GetInstance(pracownik);
		DefinicjaElementu def = płace.DefElementow[guid];
        try {
		    foreach (WypElement e in pracownik.Elementy[okres])
			    if (e.Definicja==def && e.SkładnikGłówny!=null)
				    t += e.SkładnikGłówny.Czas;
        }
        catch { Msg(); }
		return t;				
    }
    
    int Dni(Time t, Time norma) {
		int mt = t.TotalMinutes;
		int mn = norma.TotalMinutes;
		return mt/mn;
    }
    
    string Godz(Time t, Time norma) {
		int mt = t.TotalMinutes;
		int mn = norma.TotalMinutes;
		int m = mt%mn;
		if (m==0)
			return "";
		return "i <strong>" + new Time(0, m) +"</strong> godz. ";
    }
    
    static void Msg(object v) {
    }

    public static ReportHeader report;

    public static void Msg() {
        string msg = "Wydruk przygotowany na podstawie danych, do których operator ma prawa dostępu";
        if (report != null && !report.Title.Contains(msg))
            report.Title += "|" + msg;
    }

	</script>

	<meta content="False" name="vs_showGrid">
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
	<meta content="C#" name="CODE_LANGUAGE">
	<meta content="JavaScript" name="vs_defaultClientScript">
	<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="UmowaOPracę" method="post" runat="server">
			<EA:DATACONTEXT id="dc" runat="server" oncontextload="OnContextLoad" TypeName="Soneta.Kadry.PracHistoria, Soneta.KadryPlace"></EA:DATACONTEXT>
            <ea:DataRepeater ID="DataRepeater1" runat="server" RowTypeName="Soneta.Kadry.PracHistoria, Soneta.KadryPlace" Width="100%" Height="161px">
            <ea:SectionMarker ID="SectionMarker9" runat="server"></ea:SectionMarker>
		    <ea:PageBreak ID="PageBreak1" runat="server" BreakFirstTimes="False" 
				ResetPageCounter="True"></ea:PageBreak>
            <cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="Świadectwo pracy" runat="server"></cc1:reportheader>
			<table id="Table0" cellSpacing="0" width="100%" columns="1" style="font-size: 10pt; font-family: tahoma; text-align:right">
			<tbody>
				<tr>
					<td valign="top" align="right">
						<ea:datalabel id="labelMiejscowosc" runat="server"></ea:datalabel>,
						<ea:datalabel id="labelData" runat="server"></ea:datalabel>
					</td>
                </tr>
            </tbody>
            </table>
			<p></p>
			<font face="Tahoma" size="2">
				<p style="text-align:left">
					REGON:
					<ea:datalabel id="PieczątkaREGON" runat="server"></ea:datalabel>
				</p>
			</font>

			<table id="Table1" cellSpacing="0" width="100%" columns="3" style="font-size: 10pt; font-family: tahoma; text-align:left">
			<tbody>
				<tr>
					<td width="30px" valign="top" align="right">1.</td><td width="5px"></td>
					<td>Stwierdza się, że
						<ea:datalabel id="DataLabel2" runat="server" DataMember="Plec" Bold="False">
							<ValuesMap>
								<ea:ValuesPair Key="Kobieta" Value="Pani"></ea:ValuesPair>
								<ea:ValuesPair Key="Mężczyzna" Value="Pan"></ea:ValuesPair>
							</ValuesMap>
						</ea:datalabel>
						<ea:datalabel id="Datalabel34" runat="server" DataMember="Pracownik.ImięNazwisko"></ea:datalabel>,
                        imiona rodziców:
						<ea:datalabel id="Datalabel36" runat="server" DataMember="ImieOjca"></ea:datalabel>,
						<ea:datalabel id="Datalabel37" runat="server" DataMember="ImieMatki"></ea:datalabel>,
						<br/>
						<ea:datalabel id="DataLabel3" runat="server" DataMember="Plec" Bold="False">
							<ValuesMap>
								<ea:ValuesPair Key="Kobieta" Value="urodzona"></ea:ValuesPair>
								<ea:ValuesPair Key="Mężczyzna" Value="urodzony"></ea:ValuesPair>
							</ValuesMap>
						</ea:datalabel>&nbsp;
						<ea:datalabel id="Datalabel38" runat="server" DataMember="Urodzony.Data"></ea:datalabel>&nbsp;
						<ea:datalabel id="Datalabel39" runat="server" DataMember="Urodzony.Miejsce"></ea:datalabel>,
						<br/>
						<ea:datalabel id="DataLabel1" runat="server" DataMember="Plec" Bold="False">
							<ValuesMap>
								<ea:ValuesPair Key="Kobieta" Value="była zatrudniona"></ea:ValuesPair>
								<ea:ValuesPair Key="Mężczyzna" Value="był zatrudniony"></ea:ValuesPair>
							</ValuesMap>
						</ea:datalabel>&nbsp;w:
                        <br />
                        <ea:datalabel id="labelZatrudnienie" runat="server" Bold="false"></ea:datalabel> 
					</td>
				</tr>
				<tr>
					<td width="30px" valign="top" align="right">2.</td><td width="5px"></td>
					<td>W okresie zatrudnienia
						<ea:datalabel id="DataLabel11" runat="server" DataMember="Plec" Bold="False">
							<ValuesMap>
								<ea:ValuesPair Key="Kobieta" Value="pracownik wykonywał"></ea:ValuesPair>
								<ea:ValuesPair Key="Mężczyzna" Value="pracownik wykonywał"></ea:ValuesPair>
							</ValuesMap>
						</ea:datalabel>
						pracę:
					</td>
				</tr>
				<tr>
					<td width="30px" valign="top" align="right"></td><td width="5px"></td>
					<td>
						<ea:datalabel id="labelStanowisko" runat="server" Bold="False"></ea:datalabel>
					</td>
				</tr>
				<tr>
					<td width="30px" valign="top" align="right">3.</td><td width="5px"></td>
					<td>Stosunek pracy ustał w wyniku:</td>
				</tr>
				<tr>
					<td width="30px" valign="top" align="right"></td><td width="5px"></td>
					<td>
						<ea:datalabel id="labelPrzyczyna" runat="server"></ea:datalabel>
					</td>
				</tr>
				<tr>
					<td width="30px" valign="top" align="right">4.</td><td width="5px"></td>
					<td>W okresie zatrudnienia pracownik:</td>
				</tr>
			</tbody>
			</table>
					
			<table id="Table6" cellSpacing="0" width="100%" columns="3" style="font-size: 10pt; font-family: tahoma; text-align:justify">
			<tbody>
				<tr>
					<td width="60px" valign="top" align="right">1)</td><td width="5px"></td>
					<td>wykorzystał urlop wypoczynkowy w wymiarze&nbsp;
						<ea:datalabel id="wypoczynkowy" runat="server"></ea:datalabel>
						&nbsp;dni&nbsp;<ea:datalabel id="wypoczynkowyT" runat="server" Bold="False"></ea:datalabel>
						(<ea:datalabel id="wypoczynkowyG" runat="server"></ea:datalabel>
						&nbsp;godz.<ea:datalabel id="ekwiwalentG" runat="server" Bold="False"></ea:datalabel>)
                        <ea:Section ID="desc1" runat="server">
                            <em>(urlop wypoczynkowy wykorzystany w roku kalendarzowym, w którym ustał stosunek pracy)</em>
                        </ea:Section>
                        ,<br/>w tym
						<ea:datalabel id="wypoczynkowy167" runat="server"></ea:datalabel>&nbsp;dni
						(<ea:datalabel id="wypoczynkowy167G" runat="server"></ea:datalabel>&nbsp;godz.) 
						urlopu na żądanie
                        <ea:Section ID="desc2" runat="server">
                            <em>(urlop wypoczynkowy wykorzystany na podstawie art. 167<sup>2</sup> Kodeksu pracy w roku kalendarzowym, w którym ustał stosunek pracy)</em>
                        </ea:Section>
					</td>
				</tr>
                <tr>
					<td width="60px" valign="top" align="right">2)</td><td width="5px"></td>
					<td>korzystał z urlopu bezpłatnego:
                        <ea:datalabel id="urlopbezplatny" runat="server"></ea:datalabel>                    
                    </td>
				</tr>
            </tbody>
            </table>				

			<ea:pagebreak id="PageBreak5" runat="server" Required="False"></ea:pagebreak>
			
			<ea:Grid id="Grid2" runat="server" onbeforerow="Grid2_BeforeRow">
				<Columns>
					<ea:GridColumn runat="server" width="8" Align="Right" Caption="Lp" DataMember="#"></ea:GridColumn>
					<ea:GridColumn runat="server" width="20" Align="Right" ID="col2OkresOd" Caption="Okres~Od"></ea:GridColumn>
					<ea:GridColumn runat="server" width="20" Align="Right" ID="col2OkresDo" Caption="Okres~Do"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Right" ID="col2Nazwa" Caption="Nazwa okresu"></ea:GridColumn>
				</Columns>
			</ea:Grid>

            <ea:Section ID="desc3" runat="server">
			    <table id="Table2" cellSpacing="0" width="100%" columns="2" style="font-size: 10pt; font-family: tahoma; text-align:justify">
			    <tbody>
				    <tr>
					    <td width="80px"></td>
					    <td valign="top" align="left">
						    <em>(okres trwania urlopu bezpłatnego i podstawa prawna jego udzielenia)</em>
					    </td>
				    </tr>
                </tbody>
                </table>
            </ea:Section>

			<ea:pagebreak id="PageBreak7" runat="server" Required="False"></ea:pagebreak>

			<table id="Table3" cellSpacing="0" width="100%" columns="3" style="font-size: 10pt; font-family: tahoma; text-align:justify">
			<tbody>
				<tr>
					<td width="60px" valign="top" align="right">3)</td><td width="5px"></td>
					<td>wykorzystał urlop wychowawczy:&nbsp;
						<ea:datalabel id="wychowawczy" runat="server"></ea:datalabel>&nbsp;
                        <ea:Section ID="desc4" runat="server">
                            <em>(okres wykorzystanego urlopu wychowawczego)</em>
                        </ea:Section>
					</td>
				</tr>
				<tr>
					<td width="60px" valign="top" align="right">4)</td><td width="5px"></td>
					<td>był niezdolny do pracy przez okres
						<ea:datalabel id="wynagrodz92" runat="server"></ea:datalabel>&nbsp;dni
                        <ea:Section ID="desc5" runat="server">
                            <em>(liczba dni, za które pracownik otrzymał wynagrodzenie - zgodnie z art. 92 Kodeksu pracy,
                            w roku kalendarzowym, w którym ustał stosunek pracy)</em>
                        </ea:Section>
					</td>
				</tr>
				<tr>
					<td width="60px" valign="top" align="right">5)</td><td width="5px"></td>
					<td>wykorzystał zwolnienie od pracy przewidziane w art. 188 Kodeksu pracy:
						<ea:datalabel id="opieka188" runat="server"></ea:datalabel>
                        <ea:Section ID="desc6" runat="server">
                            <em><ea:datalabel id="opieka188opis" runat="server" Bold="false"></ea:datalabel></em>
                        </ea:Section>
					</td>
				</tr>
				<tr>
					<td width="60px" valign="top" align="right">6)</td><td width="5px"></td>
					<td>został zastosowany skrócony okres wypowiedzenia umowy o pracę na podstawie art. 
						36<sup>1</sup> § 1 Kodeksu pracy:
						<ea:datalabel id="skrOkres" runat="server"></ea:datalabel>&nbsp;
                        <ea:Section ID="desc7" runat="server">
                            <em>(okres, o który został skrócony okres wypowiedzenia, uprawniający do odszkodowania)</em>
                        </ea:Section>
					</td>
				</tr>
				<tr>
					<td width="60px" valign="top" align="right">7)</td><td width="5px"></td>
					<td>odbył służbę wojskową w okresie:
						<ea:datalabel id="służba" runat="server"></ea:datalabel>&nbsp;
                        <ea:Section ID="desc8" runat="server">
                            <em>(okres odbywania czynnej służby wojskowej lub jej form zastępczych)</em>
                        </ea:Section>
					</td>
				</tr>
				<tr>
					<td width="60px" valign="top" align="right">8)</td><td width="5px"></td>
					<td>wykonywał pracę w szczególnych warunkach lub w szczególnym charakterze:
						<ea:datalabel id="szWarunki" runat="server"></ea:datalabel>&nbsp;
                        <ea:Section ID="desc9" runat="server">
    						<em>(okresy wykonywania pracy oraz jej rodzaj i zajmowane stanowiska)</em>
                        </ea:Section>
					</td>
				</tr>
				<tr>
					<td width="60px" valign="top" align="right">9)</td><td width="5px"></td>
					<td>wykorzystał dodatkowy urlop albo inne uprawnienia lub świadczenia 
						przewidziane przepisami prawa pracy:
						<ea:datalabel id="dodUrlop" runat="server" Bold="false"></ea:datalabel>
					</td>
				</tr>
				<tr>
					<td width="60px" valign="top" align="right">10)</td><td width="5px"></td>
					<td>okresy nieskładkowe:&nbsp;
						<ea:datalabel id="okresyNS" runat="server" Bold="false"></ea:datalabel>
                    </td>
				</tr>
			</tbody>
			</table>
				
			<ea:pagebreak id="PageBreak2" runat="server" Required="False"></ea:pagebreak>
			
			<ea:Grid id="Grid1" runat="server" onbeforerow="Grid1_BeforeRow">
				<Columns>
					<ea:GridColumn runat="server" width="8" Align="Right" Caption="Lp" DataMember="#"></ea:GridColumn>
					<ea:GridColumn runat="server" width="20" Align="Right" ID="col1OkresOd" Caption="Okres nieskładkowy~Od"></ea:GridColumn>
					<ea:GridColumn runat="server" width="20" Align="Right" ID="col1OkresDo" Caption="Okres nieskładkowy~Do"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Right" ID="col1Nazwa" Caption="Nazwa okresu"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			
            <ea:Section ID="desc10" runat="server">
			    <table id="Table7" cellSpacing="0" width="100%" columns="2" style="font-size: 10pt; font-family: tahoma; text-align:justify">
			    <tbody>
				    <tr>
					    <td width="80px"></td>
					    <td valign="top" align="left">
						    <em>(okresy nieskładkowe, przypadające w okresie zatrudnienia wskazanym w ust. 1, 
						    uwzględniane przy ustalaniu prawa do emerytury lub renty)</em>
					    </td>
				    </tr>
			    </tbody>
			    </table>
			</ea:Section>

			<ea:pagebreak id="PageBreak3" runat="server" Required="False"></ea:pagebreak>
			
			<table id="Table8" cellSpacing="0" width="100%" columns="3" style="font-size: 10pt; font-family: tahoma; text-align:justify">
			<tbody>
				<tr>
					<td width="60px" valign="top" align="right">11)</td><td width="5px"></td>
					<td>dni, za które pracownik nie zachował prawa do wynagrodzenia:
						<ea:datalabel id="nieWyn" runat="server"></ea:datalabel>&nbsp;
                        <ea:Section ID="desc11" runat="server">
                            <em>(dni, za które pracownik nie zachował prawa do wynagrodzenia, zgodnie z art. 92 
	    					    § 1<sup>1</sup> Kodeksu pracy, przypadające w okresie od dnia 1 stycznia 2003 r. do dnia 31 grudnia 2003 r.)</em>
                        </ea:Section>
					</td>
				</tr>
			</tbody>
			</table>
						
			<ea:pagebreak id="PageBreak4" runat="server" Required="False"></ea:pagebreak>
			
			<table id="Table9" cellSpacing="0" width="100%" columns="3" style="font-size: 10pt; font-family: tahoma; text-align:justify">
			<tbody>
				<tr>
					<td width="30px" valign="top" align="right">5.</td><td width="5px"></td>
					<td>Informacja o zajęciu wynagrodzenia
                        <ea:Section ID="desc12" runat="server">
                            <em>(oznaczenie komornika i numer sprawy egzekucyjnej)</em>:&nbsp;
                        </ea:Section>
						<ea:datalabel id="komornik" runat="server" Bold="false"></ea:datalabel>
					</td>
				</tr>
				<tr>
					<td width="30px" valign="top" align="right">6.</td><td width="5px"></td>
					<td>Informacje uzupełniające:&nbsp;
						<ea:datalabel id="dodatkowe" runat="server"></ea:datalabel><br/><br/>
					</td>
				</tr>
			</tbody>
			</table>
			
			<table id="Table11" cellSpacing="0" width="100%" columns="3" style="font-size: 10pt; font-family: tahoma; text-align:right">
			<tbody>
				<tr height="30px">
					<td>&nbsp;</td>
				</tr>
				<tr>
					<td width="50%"></td>
					<td>.............................................................&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
				</tr>
				<tr>
					<td width="50%"></td>
					<td>
						<font size="1">pieczęć i podpis pracodawcy lub osoby działającej w jego imieniu</font>
					</td>
				</tr>
			</tbody>
			</table>
						
			<ea:pagebreak id="PageBreak6" runat="server" Required="False"></ea:pagebreak>
			
			<font face="Tahoma" size="1">
				<p style="text-align:justify">POUCZENIE<br/>
					Pracownik może w ciągu 7 dni od dnia otrzymania świadectwa pracy wystąpić do 
					pracodawcy z wnioskiem o sprostowanie tego świadectwa. W razie nieuwzględnienia 
					wniosku pracownikowi przysługuje, w ciągu 7 dni od dnia otrzymania 
					zawiadomienia o odmowie sprostowania świadectwa pracy, prawo wystąpienia z 
					żądaniem sprostowania świadectwa pracy do 
                    <ea:datalabel id="sadpracy" runat="server" Bold="false"></ea:datalabel>                    
                    (podstawa prawna - art. 97 § 2<sup>1</sup> Kodeksu pracy) 
				</p>
			</font>
			<cc1:reportfooter id="ReportFooter1" runat="server" TheEnd="False"></cc1:reportfooter>
			<ea:SectionMarker ID="SectionMarker8" runat="server" SectionType="Footer"></ea:SectionMarker>
        </ea:DataRepeater>
        </form>
	</body>
</HTML>
